/*! UBIHRM ubiapp.js
 * ================
 *
 * @Author  Harish Kushwah
 * @Email   <harish@ubitechsolutions.com>
 * @version 1.0.0.0
 */

'use strict';

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === "undefined") {
  throw new Error("UBIAptitude requires jQuery");
}
//'ui.bootstrap', 'xeditable', 'ngSanitize'

var app = angular.module('aptitude', []);
/*app.run(function(editableOptions) {
  editableOptions.theme = 'bs3'; // bootstrap3 theme. Can be also 'bs2', 'default'
});*/
 app.directive('fileUpload', function () {

    return {
        scope: true,        //create a new scope
        link: function (scope, el, attrs) {
            el.bind('change', function (event) {
                var files = event.target.files;
                //iterate files since 'multiple' may be specified on the element
                for (var i = 0;i<files.length;i++) {
                    //emit event upward
                    scope.$emit("fileSelected", { file: files[i] });
                }                                       
            });
        }
    };	
});

/////////////Position Ctrl/////////////
app.controller('positionCtrl',function($scope, $http, $timeout) {

	$scope.hastrue=false;
	$scope.positionindex='Positions';
	$scope.positionpast='Closed Positions';
	$scope.position1='Position';
	$scope.position="Position";
	$scope.startdate="Start date";
	$scope.enddate ='End date ';
	$scope.position_list='Open Positions List';
	$scope.closeposition_list='Closed Positions List';
	$scope.add_oneliner='Add current position for assessment';
	$scope.currindex_oneliner='List of all the position  being tested.';
	$scope.pastindex_oneliner='Positions which were tested before. ';
	$scope.pageid=0;
	$scope.labelname="";
	
	$scope.onfetchlabel = function($id)
	{
		$scope.pageid=$id;
		$scope.hastrue=true;
		var xsrf = $.param({pageid: $id});
		$http({
			url: path+'designation/getlabel',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
		//	console.log(data.data.length);
			if(data.status){
				for(var i=0; i<data.data.length; i++){
					if(data.data[i].idValue=="pos_1")
						$scope.position1=data.data[i].content;
					else if(data.data[i].idValue=="pos_2")
						$scope.position=data.data[i].content;
					else if(data.data[i].idValue=="pos_3")
						$scope.startdate=data.data[i].content;
					else if(data.data[i].idValue=="pos_4")
						$scope.enddate=data.data[i].content;
					else if(data.data[i].idValue=="pos_5")
						$scope.position_list=data.data[i].content;
					else if(data.data[i].idValue=="pos_6")
						$scope.positionindex=data.data[i].content;
					else if(data.data[i].idValue=="pos_7")
						$scope.positionpast=data.data[i].content;
					else if(data.data[i].idValue=="pos_8")
						$scope.closeposition_list=data.data[i].content;
					else if(data.data[i].idValue=="pos_9")
						$scope.add_oneliner=data.data[i].content;	
					else if(data.data[i].idValue=="pos_10")
						$scope.currindex_oneliner=data.data[i].content;	
					else if(data.data[i].idValue=="pos_11")
						$scope.pastindex_oneliner=data.data[i].content;
				}
				
			}
			$scope.hastrue=false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.getlabeldata=function($labelid){
		//alert($labelid);
		$scope.labelid=$labelid;
		var xsrf = $.param({pageid: $scope.pageid,label:$labelid});
		$http({
			url: path+"designation/getlabeldata",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		 }).success(function (data, status, headers, config) {
			// console.log(data.status);
				if(data.status){
				$("#change-label").modal('show');
				$scope.labelname=data.data[0]['content'];
				}else{
					$scope.labelname="";
				$("#change-label").modal('show');
				}
		}).error(function (data, status, headers, config) {
			
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
		});
	}
	
	$scope.add_update = function($val)
	{
		$scope.hastrue=true;
		var xsrf = $.param({pageid: $scope.pageid, label:$scope.labelid, labelname: $scope.labelname});
		
		$http({
			url : path+'designation/createlabel',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			console.log(data.status);
			if(data.status){
				alert("Changed Successfully");
			$scope.onfetchlabel($scope.pageid);
			}
			
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
	}
	
});

/////////////Candidate Ctrl/////////////
app.controller('candidateCtrl',function($scope, $http, $timeout) {

	$scope.hastrue=false;
	$scope.candidate1='Candidate';
	$scope.can_name="Candidate Name";
	$scope.can_photo="Upload Photo";
	$scope.can_pos ='Position';
	$scope.can_con=	'Contact Number';
	$scope.can_email='Email';
	$scope.can_pass='Password';
	$scope.can_city='City';
	$scope.can_add=	'Address';
	$scope.can_current=	' Current Candidates ';
	$scope.curr_can_oneliner=	'Candidates for Open Positions. ';
	$scope.curr_candidate=	'Current Candidates List ';
	$scope.can_past=	'Past Candidates ';
	$scope.past_can_oneliner=	'Candidates registered for Closed Position. ';
	$scope.past_candidate=	'Past Candidates List';
	$scope.can_feedback=	'Candidates Feedback';
	$scope.can_feedback_oneliner='Feedback given by the Candidates after test.';
	$scope.can_feedback_list=	'Candidates Feedback List ';
	$scope.can_taking_test=	'Taking Test ';
	$scope.can_taking_oneliner='Candidates taking tests at present. ';
	$scope.can_taking_list=	'Candidates Taking Test List ';
	$scope.Import ='Import Candidates ';
    $scope.ImportCandidates ='Import Candidates ';
	$scope.Importoneline ='Import Candidates ';
	$scope.AwaitingTests  ='Awaiting Tests  ';
	$scope.Candidates_scheduled ='Candidates scheduled for tests ';
	$scope.Candidates_Awaiting_List ='Candidates Awaiting Test List ';
	
	$scope.ResultsDeclared   ='Results Declared   ';
	$scope.Resultslist   ='List of Candidate Results for Open Positions. ';
	$scope.ResultsDeclaredlist   ='Results Declared List ';
	$scope.NoShows    ='No Shows ';
	$scope.candidateNoShows    ='Candidates who did not show up. ';
	$scope.NoShowslist    ='No Shows List ';
	$scope.pageid=0;
	$scope.labelname="";

	$scope.onfetchlabel = function($id)
	{
		$scope.pageid=$id;
		$scope.hastrue=true;
		var xsrf = $.param({pageid: $id});
		$http({
			url: path+'designation/getlabel',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
		//	console.log(data.data.length);
			if(data.status){
				for(var i=0; i<data.data.length; i++){
					if(data.data[i].idValue=="can_1")
						$scope.candidate1=data.data[i].content;
					else if(data.data[i].idValue=="can_2")
						$scope.can_name=data.data[i].content;
					else if(data.data[i].idValue=="can_3")
						$scope.can_photo=data.data[i].content;
					else if(data.data[i].idValue=="can_4")
						$scope.can_pos=data.data[i].content;
					else if(data.data[i].idValue=="can_5")
						$scope.can_con=data.data[i].content;
					else if(data.data[i].idValue=="can_6")
						$scope.can_email=data.data[i].content;
					else if(data.data[i].idValue=="can_7")
						$scope.can_pass=data.data[i].content;
					else if(data.data[i].idValue=="can_8")
						$scope.can_city=data.data[i].content;
					else if(data.data[i].idValue=="can_9")
						$scope.can_add=data.data[i].content;
			    	else if(data.data[i].idValue=="can_10")
						$scope.can_current=data.data[i].content;
			    	else if(data.data[i].idValue=="can_11")
						$scope.curr_can_onliner=data.data[i].content;
				    else if(data.data[i].idValue=="can_12")
						$scope.curr_candidate=data.data[i].content;
					else if(data.data[i].idValue=="can_13")
						$scope.can_past=data.data[i].content;
					else if(data.data[i].idValue=="can_14")
						$scope.past_can_oneliner=data.data[i].content;
					else if(data.data[i].idValue=="can_15")
						$scope.past_candidate=data.data[i].content;
					else if(data.data[i].idValue=="can_16")
						$scope.can_feedback=data.data[i].content;
					else if(data.data[i].idValue=="can_17")
						$scope.can_feedback_oneliner=data.data[i].content;
					else if(data.data[i].idValue=="can_18")
						$scope.can_feedback_list=data.data[i].content;
					else if(data.data[i].idValue=="can_19")
						$scope.can_taking_test=data.data[i].content;
					else if(data.data[i].idValue=="can_20")
						$scope.can_taking_oneliner=data.data[i].content;
					else if(data.data[i].idValue=="can_21")
						$scope.can_taking_list=data.data[i].content;
					else if(data.data[i].idValue=="can_22")
						$scope.ImportCandidates=data.data[i].content;
					else if(data.data[i].idValue=="can_23")
						$scope.Import=data.data[i].content;
					else if(data.data[i].idValue=="can_24")
						$scope.Importoneline=data.data[i].content;
					else if(data.data[i].idValue=="can_25")
						$scope.AwaitingTests=data.data[i].content;
					else if(data.data[i].idValue=="can_26")
						$scope.Candidates_scheduled=data.data[i].content;
					else if(data.data[i].idValue=="can_27")
						$scope.Candidates_Awaiting_List=data.data[i].content;
					
					else if(data.data[i].idValue=="can_29")
						$scope.ResultsDeclared=data.data[i].content;
					else if(data.data[i].idValue=="can_30")
						$scope.Resultslist=data.data[i].content;
					else if(data.data[i].idValue=="can_31")
						$scope.ResultsDeclaredlist=data.data[i].content;
					else if(data.data[i].idValue=="can_32")
						$scope.NoShows=data.data[i].content;
					else if(data.data[i].idValue=="can_33")
						$scope.candidateNoShows=data.data[i].content;
					else if(data.data[i].idValue=="can_34")
						$scope.NoShowslist=data.data[i].content;
					
				}
				
				
			}
			$scope.hastrue=false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.getlabeldata=function($labelid){
		//alert($labelid);
		$scope.labelid=$labelid;
		var xsrf = $.param({pageid: $scope.pageid,label:$labelid});
		$http({
			url: path+"designation/getlabeldata",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		 }).success(function (data, status, headers, config) {
			// console.log(data.status);
				if(data.status){
				$("#change-label").modal('show');
				$scope.labelname=data.data[0]['content'];
				}else{
					$scope.labelname="";
				$("#change-label").modal('show');
				}
		}).error(function (data, status, headers, config) {
			
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
		});
	}
	
	
	$scope.add_update = function($val)
	{
		$scope.hastrue=true;
		var xsrf = $.param({pageid: $scope.pageid, label:$scope.labelid, labelname: $scope.labelname});
		
		$http({
			url : path+'designation/createlabel',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			console.log(data.status);
			if(data.status){
				alert("Changed Successfully");
			$scope.onfetchlabel($scope.pageid);
			}
			
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
	}
	
});



/////////////TEST Ctrl/////////////
app.controller('TestCtrl',function($scope, $http, $timeout) {

	$scope.hastrue=false;
	$scope.testname='Test';
	//$scope.currenttest='Current Tests';
	//$scope.currenttestoneliner='Tests for Open Positions.';
	$scope.position="Position";
	$scope.testlevel="Test level";
	$scope.TestBank ="Test Bank";
	$scope.testoneline ='Test Papers for all Test Categories, Levels and Positions. ';
	$scope.TestPaperCategories="Test Paper Categories";
	$scope.TestPapers="Test Papers";
	$scope.Filterby="Filter by:";
	$scope.Sortby="Sort by:";
	$scope.Appearedtests  ='Appeared for tests  ';
	$scope.candidatesappearedline='All candidates who have taken tests.';
	$scope.Appearedtestlist  ='Appeared for tests List ';
	$scope.AwaitingResults   ='Awaiting Results  ';
	//$scope.Appearedtestlist  ='Appeared for tests List ';
	$scope.ListCandidatesline   ='List of Candidates whose results are yet to be declared. ';
	$scope.listCandidates  ='List of Candidates awaiting results ';
	//$scope.Appearedtestlist  ='Appeared for tests List ';
	//$scope.Appearedtests  ='Appeared for tests  ';
	//$scope.currindex_oneliner='Set tests for different Positions and their levels.';
	//$scope.pastindex_oneliner='Positions which were tested before. ';
	$scope.CurrentTests ='Current Tests ';
	$scope.CurrentResults ='Current Results ';
	$scope.ResultsOpenline ='Results for Open Positions. ';
	$scope.CurrentResultsList ='Current Results List';
	$scope.pageid=0;
	$scope.labelname="";
	
	$scope.onfetchlabel = function($id)
	{
		$scope.pageid=$id;
		$scope.hastrue=true;
		var xsrf = $.param({pageid: $id});
		$http({
			url: path+'designation/getlabel',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type' : 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
		//	console.log(data.data.length);
			if(data.status){
				for(var i=0; i<data.data.length; i++){
					if(data.data[i].idValue=="set_1")
						$scope.testname=data.data[i].content;
					else if(data.data[i].idValue=="set_2")
						$scope.position=data.data[i].content;
				    else if(data.data[i].idValue=="set_5")
						$scope.testlevel=data.data[i].content;
					else if(data.data[i].idValue=="set_6")
						$scope.TestPaperCategories=data.data[i].content;
					else if(data.data[i].idValue=="set_7")
						$scope.TestPapers=data.data[i].content;
					else if(data.data[i].idValue=="set_8")
						$scope.TestBank=data.data[i].content;
					else if(data.data[i].idValue=="set_9")
						$scope.testoneline=data.data[i].content;
					else if(data.data[i].idValue=="set_10")
						$scope.Filterby=data.data[i].content; 	
					 else if(data.data[i].idValue=="set_11")
						$scope.Sortby=data.data[i].content; 
					else if(data.data[i].idValue=="set_12")
						$scope.Appearedtests=data.data[i].content;
					else if(data.data[i].idValue=="set_13")
						$scope.candidatesappearedline=data.data[i].content;
					else if(data.data[i].idValue=="set_14")
						$scope.Appearedtestlist=data.data[i].content;
					else if(data.data[i].idValue=="set_15")
						$scope.AwaitingResults=data.data[i].content;
					else if(data.data[i].idValue=="set_16")
						$scope.ListCandidatesline=data.data[i].content;
					else if(data.data[i].idValue=="set_17")
						$scope.listCandidates=data.data[i].content;
					/* else if(data.data[i].idValue=="set_18")
						$scope.CurrentTests=data.data[i].content; */
					else if(data.data[i].idValue=="set_18")
						$scope.CurrentResults=data.data[i].content;
					else if(data.data[i].idValue=="set_19")
						$scope.ResultsOpenline=data.data[i].content;
					else if(data.data[i].idValue=="set_20")
						$scope.CurrentResultsList=data.data[i].content;
					/* else if(data.data[i].idValue=="set_3")
						$scope.currenttest=data.data[i].content;
					else if(data.data[i].idValue=="set_4")
						$scope.currenttestoneliner=data.data[i].content;  */
				}
				
			}
			$scope.hastrue=false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			$scope.hastrue=false;
		});
	}
	$scope.getlabeldata=function($labelid){
		//alert($labelid);
		$scope.labelid=$labelid;
		var xsrf = $.param({pageid: $scope.pageid,label:$labelid});
		$http({
			url: path+"designation/getlabeldata",
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		 }).success(function (data, status, headers, config) {
			// console.log(data.status);
				if(data.status){
				$("#change-label").modal('show');
				$scope.labelname=data.data[0]['content'];
				}else{
					$scope.labelname="";
				$("#change-label").modal('show');
				}
		}).error(function (data, status, headers, config) {
			
			//errorMessage("error: "+$scope.status);//$scope.status = status + ' ' + headers;
			
		});
	}
	
	$scope.add_update = function($val)
	{
		$scope.hastrue=true;
		var xsrf = $.param({pageid: $scope.pageid, label:$scope.labelid, labelname: $scope.labelname});
		
		$http({
			url : path+'designation/createlabel',
			method: "POST",
			data: xsrf,
			headers: {'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'}
		}).success(function(data, status, headers, config){
			console.log(data.status);
			if(data.status){
				alert("Changed Successfully");
			$scope.onfetchlabel($scope.pageid);
			}
			
			$scope.hastrue = false;
		}).error(function(data, status, headers, config){
			//errorMessage("error: "+$scope.status);
			$scope.hastrue=false;
		});
	}
	
	
});

